﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;


/*  LINQ-ready datasources 
    LINQ Providers
    LINQ to Objects 
 
    querying the file system */
namespace Lessons
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
        }


        /* querying a custom LINQ-ready class */
        private void button1_Click(object sender, EventArgs e)
        {
            CustomList list = new CustomList();

            var q = from n in list
                    where n >= 5
                    orderby n
                    select n;

            string S = "";

            foreach (int n in q)
                S += n.ToString() + Environment.NewLine;

            MessageBox.Show(S);
        }

        /* returns a list of FileInfo objects for files found in path */
        List<FileInfo> GetFileListOf(string path)
        {
            List<FileInfo> Result = new List<FileInfo>();

            string[] files = Directory.GetFiles(path, "*.*", SearchOption.AllDirectories);

            foreach (string s in files)
                Result.Add(new FileInfo(s));

            return Result;
        }

        /* groups and presents file names by extension */
        private void button2_Click(object sender, EventArgs e)
        {
            string path =  Path.GetFullPath(@"..\..\");

            List<FileInfo> fileList = GetFileListOf(path);

            var q = from FI in fileList
                    group FI.Name by FI.Extension.ToUpper() into g
                    orderby g.Key
                    select g;
                    

            string S = "";

            foreach (var g in q)
            {
                S += g.Key + Environment.NewLine;
                foreach (string fileName in g)
                    S += "     " + fileName + Environment.NewLine;
            }

            MessageBox.Show(S);

        }
    }
}


namespace Lessons
{
    /* a LINQ-ready class  */
    public class CustomList: IEnumerable<int>
    {
        private List<int> list = new List<int> { 0, 8, 5, 2, 9, 3, 7, 1, 6, 4 }; 

        public IEnumerator<int> GetEnumerator()
        {
            for (int i = 0; i < list.Count; i++)
                yield return list[i];
        }

        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            for (int i = 0; i < list.Count; i++)
                yield return list[i];
        }
    }
}
